#version 330

uniform sampler2D color0Tex;
uniform sampler2D shadowTex;
uniform sampler1D gradientTex;
uniform mat4 invPersp;
uniform float farClip;
uniform vec4 viewSpaceLight0;

in vec4 uv;

out vec4 oColor;

vec3 decodeNormal(vec2 enc)
{
    vec2 fenc = enc*4 - 2;
    float f = dot(fenc, fenc);
    float g = sqrt(1 - f/4);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1 - f/2;
    return n;
}

vec4 screenToProj(vec2 iCoord)
{
    return vec4(2.0f * vec2(iCoord.x, 1.0f - iCoord.y) - 1, 0.0, 1.0);
}

vec3 depthToPosition(float iDepth, vec4 iPosProj)
{
    vec3 vPosView = (invPersp * iPosProj).xyz;
    vec3 vViewRay = vec3(vPosView.xy * (farClip / vPosView.z), farClip);
    vec3 vPosition = vViewRay * iDepth;
    return vPosition;
}

void main()
{
	vec4 normalDepth = textureLod(color0Tex, uv.xy, 0);
	float shadow = textureLod(shadowTex, uv.xy, 0).r;
	
	vec3 N = decodeNormal(normalDepth.xy);
	
	vec4 projSpacePos = screenToProj(uv.xy);
	vec3 viewSpacePos = depthToPosition(normalDepth.z, projSpacePos);
	
	vec3 LightDir = normalize(-viewSpaceLight0.xyz);
	float NdotL = dot(LightDir, N);
	
	vec3 EyeDir = normalize(-viewSpacePos.xyz);
	
	vec3 HalfAngle = normalize(LightDir + EyeDir);
	float NdotH = max(0.0, dot(HalfAngle, N));
	float specular = NdotH > 0 ? pow(NdotH, 73.1707) : 0.0;
	float SpecularLight = NdotL > 0.0 ? specular : 0.0;
	
	float lightIntensity = max(NdotL, 0.0)*shadow;
	
	oColor.rgb = textureLod(gradientTex, lightIntensity, 0).rgb;
	oColor.a = SpecularLight*shadow;
}
